<?php
include("config.php");

if(!isset($_SESSION['user_id']) && !isset($_SESSION['login']) ){
    header('location:./');
}

$id = $_SESSION['user_id'];

$query = mysqli_query($con, "SELECT * FROM account WHERE id ='$id' ");

$fetch = mysqli_fetch_assoc($query);

$acc_no = $fetch['acc_no'];

?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Transactions - Banking Website</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css" />
    <link rel="stylesheet" href="style.css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    <style>
        /* Add smooth transitions */
        .transaction-item {
            transition: opacity 0.3s ease;
            opacity: 1;
            display: flex;
        }

        .transaction-item.hidden {
            opacity: 0;
            display: none;
        }

        /* Active filter button style */
        .filter-button.active {
            background-color: #7b1fa2;
            color: white;
        }
    </style>
</head>

<body>

    <div class="content-wrapper">
        <header class="site-header">
            <a href="account" class="back-link"><i class="fa-solid fa-arrow-left"></i></a>
            <h1 class="title" style="font-size: 1rem;">My transactions</h1>
            <i class="fa-solid fa-ellipsis more-options-icon"></i>
        </header>

        <main class="page-content">
            <div class="tabs">
                <button class="tab-button active">Transactions</button>
                <button class="tab-button">Spending</button>
            </div>
            <div class="account-header">
                <div class="account-details">
                    <h4><?= $fetch['fname'] . " " . $fetch['lname'] ?></h4>
                    <p> <i class="fa fa-info-circle" style="font-size: xx-small; color: #7b1fa2;"></i>
                        <?= $fetch['type'] ?> - <?= $fetch['acc_no'] ?> - <?=$fetch['reg_date'] ?></p>
                </div>
            </div>
            <div style="display:flex; justify-content: space-between; margin-bottom: 20px;">
                <div class="account-icon wallet-icon"><i class="fa-solid fa-wallet"></i></div>
                <div style="display: flex; align-items: center; gap: 5px;">
                    <i class="fa fa-info-circle" style="font-size: xx-small; color: #7b1fa2;"></i>
                    <div class="account-balance " style="font-weight: bold;">£<?= number_format($fetch['a_bal']) ?></div>
                </div>
            </div>

            <div class="transaction-controls">
                <div class="filters">
                    <button class="filter-button active">All</button>
                    <button class="filter-button">In</button>
                    <button class="filter-button">Out</button>
                </div>
                <div class="action-icons">
                    <i class="fa-solid fa-paperclip"></i>
                    <i class="fa-solid fa-calendar-days"></i>
                    <i class="fa-solid fa-magnifying-glass"></i>
                </div>
            </div>

       

            <div class="transaction-list">
                
            <?php
                
                $query_trans = mysqli_query($con, "SELECT * FROM alerts WHERE uname = '$acc_no' ORDER BY STR_TO_DATE(date, '%m/%d/%Y') DESC");
                
                $transactions_by_date = [];
                
                    while( $rows = mysqli_fetch_assoc($query_trans)){
                        
                        $date = date('Y-m-d', strtotime($rows['date']));
                        
                         if (!isset($transactions_by_date[$date])) {
                            $transactions_by_date[$date] = [];
                        }
                        
                        $transactions_by_date[$date][] = $rows;
                }
                
                
                foreach($transactions_by_date as $date_key => $date_transaction ){
                ?>
                <div class="transaction-group">
                    
                    <?php
                            $givenTimestamp = strtotime($date_key);
                            $currentTimestamp = time();
                            
                            $differenceInSeconds = abs($currentTimestamp - $givenTimestamp);
                            
                            $dayDifference = abs(floor(($currentTimestamp - $givenTimestamp) / (60 * 60 * 24)));
                            
                            $current = $differenceInSeconds < (24 * 60 * 60) ? "Today" : 
                                ( $dayDifference == 1 ? "Yesterday"
                                   : date("d M Y", strtotime($date_key) ) );
                            
                    ?>
                    
                    <h5 class="date-header"><?= $current ?></h5>
                    
                   <?php
                            foreach($date_transaction as $date_transaction_key => $date_transaction_value){
                        ?>
                         <li class="transaction-item" data-type="<?= $date_transaction_value['type'] =='Credit' ? 'in' : 'out' ?>">
                            <div class="transaction-icon" style="background-color: #7b1fa2;"><i class="fa-solid fa-star"></i></div>
                            <div class="account-details">
                                <p><?= $date_transaction_value['remarks'] ?></p>
                            </div>
                            <div class="account-balance <?= $date_transaction_value['type'] =='Credit' ? 'incoming' : 'outgoing' ?>">
                                <?= $date_transaction_value['type'] =='Credit' ? '+' : '-' ?>£<?= number_format($date_transaction_value['amount']) ?></div>
                        </li>
                    
                    <?php
                            
                        }
                    
                    ?>
                    
                    </div>
                
                <?php
                }
            ?>
            
            
            
            
            
                
              <!--  <div class="transaction-group">
                    <h5 class="date-header">Yesterday</h5>
                    <ul>
                        <li class="transaction-item" data-type="in">
                            <div class="transaction-icon" style="background-color: #7b1fa2;"><i class="fa-solid fa-star"></i></div>
                            <div class="account-details">
                                <p>NATTY</p>
                            </div>
                            <div class="account-balance incoming">+£50.00</div>
                        </li>
                        <li class="transaction-item" data-type="out">
                            <div class="transaction-icon" style="background-color: #7b1fa2;">D</div>
                            <div class="account-details">
                                <p>Delice Sambi</p>
                            </div>
                            <div class="account-balance outgoing">-£50.00</div>
                        </li>
                    </ul>
                </div>
           
                <div class="transaction-group">
                    <h5 class="date-header">15 Aug 2025</h5>
                    <ul>
                        <li class="transaction-item" data-type="in">
                            <div class="transaction-icon" style="background-color: #7b1fa2;"><i class="fa-solid fa-star"></i></div>
                            <div class="account-details">
                                <p>NATTY</p>
                            </div>
                            <div class="account-balance incoming">+£30.00</div>
                        </li>
                    </ul>
                </div>
            </div>-->
        </main>

        <footer class="site-footer">
            <nav class="bottom-nav">
                <a href="account" class="nav-item"><i class="fa-solid fa-house"></i><span>Home</span></a>
                <a href="#" class="nav-item"><i class="fa-regular fa-comment"></i><span>Help</span></a>
                <a href="payment" class="nav-item"><i class="fa-solid fa-right-left"></i><span>Payments</span></a>
                <a href="transactions" class="nav-item"><i class="fa-solid fa-chart-simple"></i><span>Insights</span></a>
                <a href="#" class="nav-item"><i class="fa-solid fa-clone"></i><span>Apply</span></a>
            </nav>
        </footer>
    </div>

    <script>
        // Filter functionality
        const filterButtons = document.querySelectorAll('.filter-button');

        filterButtons.forEach(button => {
            button.addEventListener('click', () => {
                const filterType = button.textContent.toLowerCase();

                // Update active button
                filterButtons.forEach(btn => btn.classList.remove('active'));
                button.classList.add('active');

                // Filter transactions
                document.querySelectorAll('.transaction-item').forEach(item => {
                    if (filterType === 'all' || item.dataset.type === filterType) {
                        item.classList.remove('hidden');
                    } else {
                        item.classList.add('hidden');
                    }

                });

                // Handle empty groups
                document.querySelectorAll('.transaction-group').forEach(group => {
                    const hasVisibleTransactions = Array.from(group.querySelectorAll('.transaction-item')).some(item => !item.classList.contains('hidden'));
                    group.style.display = hasVisibleTransactions ? 'block' : 'none';
                });
            });
        });
    </script>
</body>

</html>