<?php
include("config.php");

if(!isset($_SESSION['user_id']) && !isset($_SESSION['login']) ){
    header('location:./');
}

$id = $_SESSION['user_id'];

$query = mysqli_query($con, "SELECT * FROM account WHERE id ='$id' ");

$fetch = mysqli_fetch_assoc($query);

?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>My Accounts - Banking Website</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css" />
    <link rel="stylesheet" href="style.css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">

    <style>
        .section1 .section1-icon,
        .section1-num {
            display: none !important;
        }

        .section2 {
            display: none !important;
        }

        /* When toggled */
        .home-card.active .section1-bal {
            display: none !important;
        }

        .home-card.active .section1-icon,
        .home-card.active .section1-num {
            display: block !important;
        }

        .home-card.active .section2 {
            display: flex !important;
        }

        .toggle-card {
            cursor: pointer;
            text-decoration: none;
        }
    </style>
</head>

<body>

    <div class="content-wrapper">
        <header class="site-header">
            <div class="profile-initial" style="background-color: var(--accent-color); color: black;"><?= substr($fetch['fname'], 0, 1) . substr($fetch['lname'], 0, 1) ?></div>
            <div class="header-actions">
                <div class="notification-area">
                    <i class="fa-solid fa-bell more-options-icon"></i>
                    <div class="notification-badge">46</div>
                </div>
                <i class="fa-solid fa-magnifying-glass more-options-icon"></i>
            </div>
        </header>

        <main class="page-content" style="padding-top: 5px;">
            <div class="link-bar">
                <span style="font-weight: bold;"><i class="fa-solid fa-check" style="margin-right: 10px;"></i> Approval requests</span>
                <i class="fa fa-chevron-right"></i>
            </div>


            <div class="section-header">
                <h5>Accounts</h5>
                <a href="#">Edit </a>
            </div>

            <ul class="account-card-list">
                <li class="home-card active">
                    <div class="jsf section1">
                        <a href="#" class="toggle-card">
                            <div class="account-details">
                                <h4><?= $fetch['fname'] . " ". $fetch['mname'] . " "  . $fetch['lname'] ?></h4>
                                <p style="display: flex;">
                                    <span class="section1-num"><?= $fetch['type'] ?> - <?= $fetch['acc_no'] ?> - <?=$fetch['reg_date'] ?></span>
                                </p>
                            </div>
                        </a>
                        <div class="account-balance section1-bal" style="color: #fff;">
                            £<?= number_format($fetch['t_bal']) ?>
                            <span class="available-balance">Available: £<?= number_format($fetch['a_bal']) ?></span>
                        </div>
                        <i class="fa-solid fa-ellipsis card-more-icon section1-icon"></i>
                    </div>
                    <a href="transactions" style="display:block" class="jsf section2">
                        <div class="account-icon">
                            <i class="fa-solid fa-piggy-bank"></i>
                        </div>
                        <div class="account-balance" style="color: #fff;">
                            £<?= number_format($fetch['t_bal']) ?>
                            <span class="available-balance">Available: £<?= number_format($fetch['a_bal']) ?></span>
                        </div>
                    </a>
                </li>

            

         <li class="home-card">
                    <div class="jsf section1">
                        <a href="#" class="toggle-card">
                            <div class="account-details">
                                <h4><?= $fetch['fname'] . " ". $fetch['mname'] . " "  . $fetch['lname'] ?></h4>
                                <p style="display: flex;"><?= $fetch['tax'] ?>
                                    <span class="section1-num"> - <?= $fetch['uname'] ?> - <?= $fetch['email'] ?></span>
                                </p>
                            </div>
                        </a> 
                        <div class="account-balance section1-bal" style="color: #fff;">
                            £<?= number_format($fetch['imf']) ?>
                            <span class="available-balance">Available: £<?= number_format($fetch['imf']) ?></span>
                        </div>
                        <i class="fa-solid fa-ellipsis card-more-icon section1-icon"></i>
                    </div>
                    <a href="transactions" style="display:block" class="jsf section2">
                        <div class="account-icon">
                            <i class="fa-solid fa-piggy-bank"></i>
                        </div>
                        <div class="account-balance" style="color: #fff;">
                            £<?= number_format($fetch['imf']) ?>
                            <span class="available-balance">Available: £<?= number_format($fetch['imf']) ?></span>
                        </div>
                    </a>
                </li>
            </ul>

            <div class="promo-banner" hidden>
                <span class="sparkle">✨</span> Check out what's new in your app
            </div>
        </main>

        <footer class="site-footer">
            <nav class="bottom-nav">
                <a href="account" class="nav-item"><i class="fa-solid fa-house"></i><span>Home</span></a>
                <a href="#" class="nav-item"><i class="fa-regular fa-comment"></i><span>Help</span></a>
                <a href="payment" class="nav-item"><i class="fa-solid fa-right-left"></i><span>Payments</span></a>
                <a href="transactions" class="nav-item"><i class="fa-solid fa-chart-simple"></i><span>Insights</span></a>
                <a href="#" class="nav-item"><i class="fa-solid fa-clone"></i><span>Apply</span></a>
            </nav>
        </footer>
    </div>

    <script>
        document.querySelectorAll(".home-card .toggle-card").forEach(card => {
            card.addEventListener("click", function (e) {
                e.preventDefault();
                const homeCard = this.closest(".home-card");
                homeCard.classList.toggle("active");
            });
        });
    </script>
</body>

</html>